/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.utils;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.utils.CardImage;
import dev.lucaargolo.charta.utils.SuitImage;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_7403;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class CardImageUtils {
    public static SuitImage EMPTY_SUIT;
    public static class_9139<ByteBuf, SuitImage> SUIT_STREAM_CODEC;
    public static CardImage EMPTY_CARD;
    public static class_9139<ByteBuf, CardImage> CARD_STREAM_CODEC;

    public static <I extends CardImage> class_1043 convertImage(I image, boolean rgba, boolean glow) {
        class_1011 nativeImage = new class_1011(rgba ? class_1011.class_1012.field_4997 : class_1011.class_1012.field_4998, image.getWidth(), image.getHeight(), true);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                if (rgba) {
                    int argbColor = glow ? image.getARGBGlowPixel(x, y) : image.getARGBPixel(x, y);
                    int alpha = argbColor >> 24 & 0xFF;
                    int red = argbColor >> 16 & 0xFF;
                    int green = argbColor >> 8 & 0xFF;
                    int blue = argbColor & 0xFF;
                    int abgrColor = alpha << 24 | blue << 16 | green << 8 | red;
                    nativeImage.method_4305(x, y, abgrColor);
                    continue;
                }
                nativeImage.method_35621(x, y, image.getPixel(x, y));
            }
        }
        return new class_1043(nativeImage);
    }

    public static <I extends CardImage> void saveImage(I image, File fileToSave, class_7403 cachedOutput) {
        try {
            Charta.LOGGER.info("Saving file: {}", (Object)fileToSave.getAbsoluteFile());
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            HashingOutputStream hashedOutStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)outStream);
            image.saveToStream((OutputStream)hashedOutStream);
            cachedOutput.method_43346(fileToSave.toPath(), outStream.toByteArray(), hashedOutStream.hash());
        }
        catch (IOException e) {
            Charta.LOGGER.error("Error saving file: {}", (Object)fileToSave.getAbsoluteFile(), (Object)e);
        }
    }

    static {
        int y;
        int x;
        EMPTY_SUIT = new SuitImage();
        SUIT_STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.field_48987, CardImage::compress, SuitImage::decompress);
        EMPTY_CARD = new CardImage();
        CARD_STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.field_48987, CardImage::compress, CardImage::decompress);
        for (x = 0; x < 13; ++x) {
            for (y = 0; y < 13; ++y) {
                EMPTY_SUIT.setPixel(x, y, x > 6 ? (y > 6 ? 0 : 58) : (y > 6 ? 58 : 0), 3);
            }
        }
        for (x = 0; x < 25; ++x) {
            for (y = 0; y < 35; ++y) {
                EMPTY_CARD.setPixel(x, y, x > 12 ? (y > 17 ? 0 : 58) : (y > 17 ? 58 : 0), 3);
            }
        }
    }
}

